/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.entity.WorldlyInventoryBlockEntity;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.inventory.ContainerInventoryAccess;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.WorldHelper;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.block.inv.BotanyPotMenu;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class BlockEntityBotanyPot
extends WorldlyInventoryBlockEntity<BotanyPotContainer> {
    public static final CachedSupplier<class_2591<BlockEntityBotanyPot>> POT_TYPE = RegistryObject.deferred((class_2378)class_2378.field_11137, (String)"botanypots", (String)"botany_pot").cast();
    private static final class_2561 DEFAULT_NAME = class_2561.method_43471((String)"block.botanypots.terracotta_botany_pot");
    protected int growthTime = -1;
    protected boolean doneGrowing = false;
    protected int prevComparatorLevel = 0;
    protected int comparatorLevel = 0;
    protected int harvestDelay = -1;
    protected int exportDelay = -1;
    final Random rng = new Random();
    private long rngSeed;

    public BlockEntityBotanyPot(class_2591 potType, class_2338 pos, class_2680 state) {
        super(potType, pos, state);
        this.refreshRandom();
    }

    public boolean isHopper() {
        class_2248 class_22482;
        if (this.method_10997() != null && (class_22482 = this.method_10997().method_8320(this.method_11016()).method_26204()) instanceof BlockBotanyPot) {
            BlockBotanyPot potBlock = (BlockBotanyPot)class_22482;
            return potBlock.hasInventory();
        }
        return false;
    }

    public void refreshRandom() {
        this.rngSeed = Constants.RANDOM.nextLong();
        this.rng.setSeed(this.rngSeed);
    }

    @Nullable
    public Crop getCrop() {
        return ((BotanyPotContainer)this.getInventory()).getCrop();
    }

    @Nullable
    public Soil getSoil() {
        return ((BotanyPotContainer)this.getInventory()).getSoil();
    }

    public boolean isGrowing() {
        return this.growthTime > 0;
    }

    public boolean areGrowthConditionsMet() {
        return BotanyPotHelper.canCropGrow(this.field_11863, this.method_11016(), this, this.getSoil(), this.getCrop());
    }

    public boolean isCropHarvestable() {
        return this.doneGrowing;
    }

    public int getLightLevel() {
        Soil soil = this.getSoil();
        Crop crop = this.getCrop();
        int soilLight = soil != null ? soil.getLightLevel(this.field_11863, this.method_11016(), this) : 0;
        int cropLight = crop != null ? crop.getLightLevel(this.field_11863, this.method_11016(), this) : 0;
        return Math.max(soilLight, cropLight);
    }

    public int getGrowthTime() {
        return this.growthTime;
    }

    public int getComparatorLevel() {
        return this.comparatorLevel;
    }

    public boolean isValidSoil(class_1799 stack) {
        return BotanyPotHelper.findSoil(this.field_11863, this.method_11016(), this, stack) != null;
    }

    public boolean isValidSeed(class_1799 stack) {
        return BotanyPotHelper.findCrop(this.field_11863, this.method_11016(), this, stack) != null;
    }

    public boolean attemptAutoHarvest() {
        if (this.method_10997() != null && !this.method_10997().field_9236 && this.getCrop() != null) {
            ContainerInventoryAccess inventory = new ContainerInventoryAccess((class_1263)((BotanyPotContainer)this.getInventory()));
            this.rng.setSeed(this.rngSeed);
            List<class_1799> drops = BotanyPotHelper.generateDrop(this.rng, this.field_11863, this.method_11016(), this, this.getCrop());
            if (drops.isEmpty()) {
                return true;
            }
            boolean didCollect = false;
            for (class_1799 drop : drops) {
                if (drop.method_7960()) continue;
                int originalSize = drop.method_7947();
                for (int slot : BotanyPotContainer.STORAGE_SLOT) {
                    if (drop.method_7960()) break;
                    drop = inventory.insert(slot, drop, class_2350.field_11036, true, true);
                }
                if (drop.method_7947() == originalSize) continue;
                didCollect = true;
            }
            return didCollect;
        }
        return false;
    }

    private void attemptExport() {
        IInventoryAccess exportTo;
        if (this.method_10997() != null && !this.method_10997().field_9236 && (exportTo = Services.INVENTORY_HELPER.getInventory(this.method_10997(), this.method_11016().method_10074(), class_2350.field_11036)) != null) {
            block0: for (int potSlotId : BotanyPotContainer.STORAGE_SLOT) {
                class_1799 potStack = ((BotanyPotContainer)this.getInventory()).method_5438(potSlotId);
                if (potStack.method_7960()) continue;
                for (int exportSlotId : exportTo.getAvailableSlots()) {
                    if (exportTo.insert(exportSlotId, potStack, class_2350.field_11036, false).method_7947() == potStack.method_7947()) continue;
                    ((BotanyPotContainer)this.getInventory()).method_5447(potSlotId, exportTo.insert(exportSlotId, potStack, class_2350.field_11036, true));
                    continue block0;
                }
            }
        }
    }

    public static void tickPot(class_1937 level, class_2338 pos, class_2680 state, BlockEntityBotanyPot pot) {
        if (pot.method_11015() || pot.method_10997() == null) {
            return;
        }
        ((BotanyPotContainer)pot.getInventory()).update();
        Soil soil = pot.getSoil();
        Crop crop = pot.getCrop();
        if (soil != null) {
            soil.onTick(level, pos, pot);
        }
        if (crop != null) {
            crop.onTick(level, pos, pot);
        }
        if (pot.isHopper()) {
            if (pot.exportDelay > 0) {
                --pot.exportDelay;
            }
            if (pot.harvestDelay > 0) {
                --pot.harvestDelay;
            }
            if (pot.isCropHarvestable() && crop != null && pot.harvestDelay < 1) {
                if (pot.attemptAutoHarvest()) {
                    pot.resetGrowth();
                }
                pot.harvestDelay = 100;
            }
            if (pot.exportDelay < 1) {
                pot.attemptExport();
                pot.exportDelay = 20;
            }
        }
        if (soil != null && crop != null && pot.areGrowthConditionsMet()) {
            if (!pot.doneGrowing) {
                boolean finishedGrowing;
                ++pot.growthTime;
                soil.onGrowthTick(level, pos, pot, crop);
                crop.onGrowthTick(level, pos, pot, soil);
                pot.prevComparatorLevel = pot.comparatorLevel;
                pot.comparatorLevel = class_3532.method_15375((float)(15.0f * ((float)pot.growthTime / (float)((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime())));
                boolean bl = finishedGrowing = pot.growthTime >= ((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime();
                if (pot.doneGrowing != finishedGrowing) {
                    pot.doneGrowing = finishedGrowing;
                    pot.markDirty();
                }
            }
        } else if (pot.growthTime != -1 || pot.doneGrowing || pot.comparatorLevel != 0) {
            pot.resetGrowth();
        }
        if (pot.comparatorLevel != pot.prevComparatorLevel) {
            pot.prevComparatorLevel = pot.comparatorLevel;
            pot.field_11863.method_8455(pot.field_11867, pot.method_11010().method_26204());
        }
    }

    public void resetGrowth() {
        this.growthTime = -1;
        this.comparatorLevel = 0;
        this.prevComparatorLevel = 0;
        this.doneGrowing = false;
        this.refreshRandom();
        this.markDirty();
    }

    public void markDirty() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            super.markDirty();
            WorldHelper.updateBlockEntity((class_2586)this, (boolean)false);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.growthTime = (Integer)Serializers.INT.fromNBT(tag, "GrowthTime", (Object)0);
        this.doneGrowing = (Boolean)Serializers.BOOLEAN.fromNBT(tag, "DoneGrowing", (Object)false);
        this.prevComparatorLevel = (Integer)Serializers.INT.fromNBT(tag, "PrevComparatorLevel", (Object)0);
        this.comparatorLevel = (Integer)Serializers.INT.fromNBT(tag, "ComparatorLevel", (Object)0);
        this.harvestDelay = (Integer)Serializers.INT.fromNBT(tag, "HarvestDelay", (Object)-1);
        this.exportDelay = (Integer)Serializers.INT.fromNBT(tag, "ExportDelay", (Object)-1);
        this.rngSeed = (Long)Serializers.LONG.fromNBT(tag, "RandomSeed", (Object)Constants.RANDOM.nextLong());
        this.rng.setSeed(this.rngSeed);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        Serializers.INT.toNBT(tag, "GrowthTime", (Object)this.growthTime);
        Serializers.BOOLEAN.toNBT(tag, "DoneGrowing", (Object)this.doneGrowing);
        Serializers.INT.toNBT(tag, "PrevComparatorLevel", (Object)this.prevComparatorLevel);
        Serializers.INT.toNBT(tag, "ComparatorLevel", (Object)this.comparatorLevel);
        Serializers.INT.toNBT(tag, "HarvestDelay", (Object)this.harvestDelay);
        Serializers.INT.toNBT(tag, "ExportDelay", (Object)this.exportDelay);
        Serializers.LONG.toNBT(tag, "RandomSeed", (Object)this.rngSeed);
    }

    public class_2487 method_16887() {
        class_2487 updateTag = super.method_16887();
        this.method_11007(updateTag);
        return updateTag;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public BotanyPotContainer createInventory() {
        return new BotanyPotContainer(this);
    }

    protected class_2561 method_17823() {
        return DEFAULT_NAME;
    }

    public class_1703 method_5465(int windowId, class_1661 inventory) {
        return new BotanyPotMenu(windowId, (BotanyPotContainer)this.getInventory(), inventory);
    }

    public void addGrowth(int nextIntInclusive) {
        this.growthTime += nextIntInclusive;
        this.markDirty();
    }
}

